document.addEventListener('DOMContentLoaded', () => {
    if (document.getElementById('offline-overlay')) return;

    const overlay = document.createElement('div');
    overlay.id = 'offline-overlay';

    const card = document.createElement('div');
    card.className = 'offline-card';
    overlay.appendChild(card);

    document.body.appendChild(overlay);

    let scrollTop = 0;

    const lockScroll = () => {
        scrollTop = window.scrollY;
        document.body.style.overflow = 'hidden';
    };

    const unlockScroll = () => {
        document.body.style.overflow = '';
    };

    const showOverlay = () => {
        overlay.classList.add('active');
        lockScroll();
    };

    const hideOverlay = () => {
        overlay.classList.remove('active');
        unlockScroll();
    };

    const checkConnection = () => {
        if (!navigator.onLine) {
            showOverlay();
        } else {
            hideOverlay();
        }
    };

    setInterval(checkConnection, 1000);
    checkConnection();

    window.addEventListener('online', hideOverlay);
    window.addEventListener('offline', showOverlay);
});