<link rel="stylesheet" href="style.css?v=<?= time() ?>">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link href="https://cdn.jsdelivr.net/gh/rastikerdar/vazir-font@30.1.0/dist/font-face.css" rel="stylesheet" type="text/css" />
<link href="https://fonts.googleapis.com/css2?family=Roboto+Flex:opsz,wght@8..144,100..1000&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
<script src="https://unpkg.com/lucide@latest"></script>
<script src="https://cdn.jsdelivr.net/npm/lucide@latest/dist/lucide.min.js"></script>
<script src="https://cdn.tailwindcss.com"></script>

<script src="scripts/disable-zoom.js"></script>
<script src="scripts/connection-check.js"></script>
<script src="scripts/copy-protect.js"></script>

<style>
    #offline-overlay {
        position: fixed;
        inset: 0;
        display: flex;
        align-items: center;
        justify-content: center;
        background: rgba(0, 0, 0, 0.75);
        z-index: 999999;
        pointer-events: none;
        opacity: 0;
        transition: opacity 0.5s ease;
        user-select: none;
    }

    #offline-overlay.active {
        pointer-events: auto;
        opacity: 1;
    }

    #offline-overlay .offline-card {
        width: 125px;
        height: 125px;
        background: url('images/loading.png') center/contain no-repeat;
        filter: drop-shadow(0 0px 30px rgba(255, 255, 255, 0.25));
        animation: pulse 2.5s infinite alternate ease-in-out;
    }
</style>

<?php
$sessionUserId = $_SESSION['user_id'];

$username = '';
if ($sessionUserId) {
    $userFile = __DIR__ . "/users/$sessionUserId/data.json";
    if (file_exists($userFile)) {
        $d = json_decode(file_get_contents($userFile), true);
        $username = $d['username'];
    }
}
?>

<header class="bg-[#111111]/50 py-5 w-full fixed top-0 left-0 z-50">
    <div class="mx-auto flex justify-center items-center">
        <a href="index.php">
            <img src="./images/site_logo.png"
                class="w-[175px] h-auto select-none pointer-events-none"
                alt="logo"
                oncontextmenu="return false;"
                draggable="false">
        </a>
    </div>
</header>
<div style="height: 75px;"></div>

<script>
    let lastScroll = 0;

    window.addEventListener('scroll', () => {
        const currentScroll = window.pageYOffset;

        if (currentScroll > lastScroll) {
            document.querySelector('.footer-nav').style.opacity = '0.2';
        } else {
            document.querySelector('.footer-nav').style.opacity = '1';
        }

        lastScroll = currentScroll;
    });
</script>