<?php
session_start();
if (!isset($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<style>
    @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
</style>

<body style="font-family: 'Inter', sans-serif;" class="mx-auto my-auto bg-white flex items-center justify-center p-4">

    <div class="w-full max-w-sm">

        <div class="flex justify-center" style="filter: invert(1);">
            <img src="../../images/loading.png" alt="logo" class="w-50 h-50 animate-pulse">
        </div>

        <h2 class="text-center text-black text-2xl font-medium mb-6">Login To Management</h2>

        <form action="../core/login.php" method="POST" id="loginForm" class="space-y-4">

            <input
                type="text"
                name="username"
                placeholder="Username"
                required
                class="w-full px-4 py-3 rounded-xl border-[1px] border-[#00000085]  text-black text-left outline-none focus:outline-none">

            <input
                type="password"
                name="password"
                placeholder="Password"
                required
                class="w-full px-4 py-3 rounded-xl border-[1px] border-[#00000085] text-black text-left outline-none focus:outline-none">

            <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">

            <button
                type="submit"
                class="w-full bg-black transition-all font-medium text-[15px] text-white p-3 rounded-xl">
                Submit
            </button>

        </form>
    </div>
</body>

</html>